<?php declare(strict_types = 1);

namespace Users\AdminModule\Presenters;

use Nette\Application\BadRequestException;
use Nette\Application\ForbiddenRequestException;
use Users\AdminModule\Components\IRoleFormFactory;
use Users\AdminModule\Components\RoleForm;
use Users\Model\Entities\Role;
use Users\Model\Roles;

class RolesPresenter extends BasePresenter
{
	public function __construct(protected Roles $rolesService)
	{
		parent::__construct();
	}

	/**
	 * @param mixed $element
	 *
	 * @throws BadRequestException
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'rolesManager')) {
			throw new ForbiddenRequestException();
		}
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionAdd(): void
	{
		$this->setHeader('users.title.newRole', 'fa fa-user-friends');
	}

	/**
	 * @throws BadRequestException
	 */
	public function actionEdit(int|string|null $id): void
	{
		$role = null;
		if (!$id || !($role = $this->rolesService->get($id))) {
			$this->error('users.roleNotFound');
		}

		if ($role->ident === Role::SUPERADMIN && !in_array(
				Role::SUPERADMIN,
				$this->getPresenter()
					->getUser()
					->getRoles(),
			)) {
			$this->error('forbidden');
		}

		$this->setHeader('users.title.editRole', 'fa fa-user-friends');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentRoleForm(IRoleFormFactory $factory): RoleForm
	{
		$control = $factory->create();

		if ($this->getParameter('id')) {
			$control->setRole($this->getParameter('id'));
		}

		$control['form']->onSuccess['redirect'] = function(): never {
			$this->redirect('Default:');
		};

		$control['form']->onCancel['redirect'] = function(): never {
			$this->redirect('Default:');
		};

		return $control;
	}
}
