<?php declare(strict_types = 1);

namespace Users\DI;

use Core\DI\CompilerExtension;
use Nette;
use Nette\DI\Definitions\ServiceDefinition;
use Nette\Security\User;

class UsersExtension extends CompilerExtension
{

	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Users' => 'Users\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		$userActivity = $builder->getDefinition('users.usersActivity');

		/** @var ServiceDefinition $user */
		$user = $builder->getDefinition($builder->getByType(User::class));
		$user->addSetup('?->onLoggedIn[] = function() use (?) {?->setFirstSignIn(?);}', [
			'@self',
			$user,
			$userActivity,
			$user,
		]);

		// Nespouštět aktualizaci oprávnění pokud se jedná o CLI
		if (php_sapi_name() !== 'cli') {
			/** @var ServiceDefinition $authorizator */
			$authorizator = $builder->getDefinition('authorizator');
			$authorizator->addSetup('setAcl', [$builder->parameters['acl'] ?: []]);
		}
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init    = $class->getMethod('initialize');
		$builder = $this->getContainerBuilder();

		$init->addBody('Users\Model\UsersConfig::setParams($this->parameters[\'users\']);');
	}
}
