<?php declare(strict_types = 1);

namespace Users\FrontModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Forms\Form;
use Nette\Security\AuthenticationException;
use Nette\Utils\ArrayHash;
use Users\Model\Entities\User;
use Users\Model\Event\UserEvent;
use Users\Model\UsersConfig;

class LoginForm extends BaseControl
{
	public function __construct(protected UsersConfig $usersConfig)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);
		$form->getElementPrototype()->class[] = 'frm__w1';
		$form->setAjax();

		$form->addText('email', 'login.loginForm.email')
			->setHtmlAttribute('placeholder', 'login.loginForm.email')
			->addRule(Form::EMAIL)->setRequired();
		$form->addPassword('password', 'login.loginForm.password')
			->setHtmlAttribute('placeholder', 'login.loginForm.password')->setRequired();

		$form->addSubmit('submit', 'login.loginForm.submit')
			->getControlPrototype()->class[] = 'primary-bg-color';

		$form->onSuccess[] = $this->formSuccess(...);

		return $form;
	}

	public function formSuccess(Form $form, ArrayHash $values): void
	{
		$presenter = $this->presenter;

		try {
			$presenter->getUser()->login($values->email, $values->password);
			$presenter->flashMessageSuccess('usersFront.loginForm.loggedIn');

			/** @var User $user */
			$user  = $presenter->getUser()->getIdentity();
			$event = new UserEvent($user);
			$this->eventDispatcher->dispatch($event, 'user.loggedIn');

			$presenter->redirect($this->usersConfig->get('redirectAfterLogin'));
		} catch (AuthenticationException $e) {
			$form->addError($e->getMessage());

			if ($presenter->isAjax()) {
				$this->redrawControl('form');
			}
		}
	}
}
