<?php declare(strict_types = 1);

namespace Users\FrontModule\Presenters;

use Users\FrontModule\Components\ForgotPasswordForm;
use Users\FrontModule\Components\IForgotPasswordFormFactory;
use Users\FrontModule\Components\ILoginFormFactory;
use Users\FrontModule\Components\INewPasswordFormFactory;
use Users\FrontModule\Components\LoginForm;
use Users\FrontModule\Components\NewPasswordForm;

class LoginPresenter extends BasePresenter
{

	protected function startup(): void
	{
		parent::startup();
		if ($this->getUser()->isLoggedIn())
			$this->redirect('Default:');
	}

	public function beforeRender(): void
	{
		parent::beforeRender();
	}

	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault(): void
	{
		$this->template->messages     = $this->getTemplate()->flashes;
		$this->getTemplate()->flashes = [];
	}

	public function actionForgotPassword(): void
	{
	}

	public function actionNewPassword(string $token, string $email): void
	{
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentLoginForm(ILoginFormFactory $factory): LoginForm
	{
		return $factory->create();
	}

	protected function createComponentForgotPasswordForm(IForgotPasswordFormFactory $factory): ForgotPasswordForm
	{
		return $factory->create();
	}

	protected function createComponentNewPasswordForm(INewPasswordFormFactory $factory): NewPasswordForm
	{
		return $factory->create();
	}
}
