<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Users\Model\Listeners\AclListener;

#[ORM\Table(name: 'user_acl')]
#[ORM\Entity]
#[ORM\EntityListeners([AclListener::class])]
class Acl
{
	use TId;

	#[ORM\ManyToOne(targetEntity: Role::class)]
	#[ORM\JoinColumn(name: 'role_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public ?Role $role;

	#[ORM\ManyToOne(targetEntity: Privilege::class)]
	#[ORM\JoinColumn(name: 'privilege_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public ?Privilege $privilege;

	#[ORM\ManyToOne(targetEntity: Resource::class)]
	#[ORM\JoinColumn(name: 'resource_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	public ?Resource $resource;

	#[ORM\Column(type: Types::SMALLINT)]
	public int $allowed = 0;

	public function __construct(?Role $role, ?Resource $resource, ?Privilege $privilege, int $allowed = 1)
	{
		$this->role      = $role;
		$this->resource  = $resource;
		$this->privilege = $privilege;
		$this->allowed   = $allowed;
	}
}
