<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Users\Model\Listeners\AclListener;

#[ORM\Table(name: 'user_privilege')]
#[ORM\Entity]
#[ORM\EntityListeners([AclListener::class])]
class Privilege
{
	use TId;

	#[ORM\Column(name: 'name', type: Types::STRING, length: 60)]
	public string $name;

	public function __construct(string $name)
	{
		$this->name = $name;
	}

}
