<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Nette\Security\Role as NetteRole;
use Users\Model\Listeners\AclListener;

#[ORM\Table(name: 'user_role')]
#[ORM\Entity]
#[ORM\EntityListeners([AclListener::class])]
class Role implements NetteRole
{
	public const GUEST      = 'guest';
	public const USER       = 'user';
	public const ADMIN      = 'admin';
	public const SUPERADMIN = 'superAdmin';

	use TId;

	#[ORM\Column(name: 'name', type: Types::STRING, length: 60)]
	public string $name;

	#[ORM\Column(name: 'ident', type: Types::STRING, length: 60)]
	public string $ident;

	#[ORM\ManyToOne(targetEntity: Role::class, inversedBy: 'childrens')]
	#[ORM\JoinColumn(name: 'parent_id', referencedColumnName: 'id', onDelete: 'SET NULL')]
	public ?Role $parent;

	/**
	 * @var Collection<Role>
	 */
	#[ORM\OneToMany(mappedBy: 'parent', targetEntity: Role::class)]
	protected Collection $childrens;

	public function __construct(string $name)
	{
		$this->name      = $name;
		$this->childrens = new ArrayCollection;
	}

	function getRoleId(): string
	{
		return $this->name;
	}

}
