<?php declare(strict_types = 1);

namespace Users\Model\Entities;

use Core\Model\Entities\TId;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Nette\Utils\DateTime;

#[ORM\Table(name: 'user_action')]
#[ORM\Entity]
class UserAction
{
	public const RESET_PASSWORD = 'resetPassword';

	use TId;

	#[ORM\Column(name: 'type', type: Types::STRING)]
	protected string $type;

	#[Gedmo\Timestampable(on: 'create')]
	#[ORM\Column(name: 'created', type: Types::DATETIME_MUTABLE)]
	protected ?DateTimeInterface $created = null;

	#[ORM\Column(name: 'token', type: Types::STRING, length: 255, nullable: false)]
	protected string $token;

	#[ORM\Column(name: 'done', type: Types::BOOLEAN, nullable: false)]
	protected bool $done = false;

	#[ORM\ManyToOne(targetEntity: User::class)]
	#[ORM\JoinColumn(name: 'user_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
	protected ?User $user;

	public function __construct(User $user, string $type, string $token)
	{
		$this->user    = $user;
		$this->type    = $type;
		$this->token   = $token;
		$this->created = new DateTime;
		$this->done    = false;
	}

	public function getType(): string
	{
		return $this->type;
	}

	public function getCreated(): DateTimeInterface { return $this->created ?: new DateTime; }

	public function getToken(): string
	{
		return $this->token;
	}

	/**
	 * @return bool
	 */
	public function isDone()
	{
		return $this->done;
	}

	/**
	 * @param int<0, 1>|bool $done
	 */
	public function setDone($done): UserAction
	{
		$this->done = $done;

		return $this;
	}

	public function getUser(): ?User
	{
		return $this->user;
	}

}
