<?php declare(strict_types = 1);

namespace Users\Model\Listeners;

use Doctrine\ORM\Event\PostPersistEventArgs;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\Authorizator;

class AclListener implements EventSubscriberInterface
{
	protected readonly Cache $cache;
	protected static bool    $cleared = false;

	public function __construct(
		Storage $cacheStorage,
	)
	{
		$this->cache = new Cache($cacheStorage, Authorizator::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostPersist]
	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(object $entity, PostPersistEventArgs|PostUpdateEventArgs|PostRemoveEventArgs $event): void
	{
		if (self::$cleared) {
			return;
		}

		$this->cache->clean([
			Cache::Tags => [Authorizator::CACHE_NAMESPACE],
		]);

		self::$cleared = true;
	}
}
