<?php declare(strict_types = 1);

namespace Users\Model\Listeners;

use Doctrine;
use Doctrine\ORM\Event\PreRemoveEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\DateTime;
use Nette\Utils\FileSystem;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Users\Model\Entities\User;

class UserListener implements EventSubscriberInterface
{

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PreUpdate]
	public function preUpdate(User $user, PreUpdateEventArgs $args): void
	{
		$user->lastModified = new DateTime;
	}

	#[ORM\PreRemove]
	public function preRemoveHandler(User $user, PreRemoveEventArgs $events): void
	{
		if ($user->getProfileImage() !== null && is_file((string) $user->getProfileImage())) {
			FileSystem::delete($user->getProfileImage());
		}
	}

}
