<?php declare(strict_types = 1);

namespace Users\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Navigations\Model\BaseItem;
use Navigations\Model\Entities\Navigation;

abstract class BaseNavigation extends BaseItem
{
	protected $langBase = 'users.navigationBuilder';

	/**
	 * @param string $presenter
	 * @param string $action
	 *
	 * @return int|bool
	 */
	public function presenterActionCheck($presenter, $action)
	{
		return $this->presenter === $presenter && $this->action === $action;
	}

	/**
	 * @param Navigation $navigation
	 * @param array      $urlParams
	 *
	 * @return array
	 */
	public function routerIn($navigation, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	/**
	 * @param array $urlParams
	 */
	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->isHomepage ? '' : '/' . $navigation->alias;
	}
}
