<?php declare(strict_types = 1);

namespace Users\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;

class Login extends BaseNavigation implements INavigationItem
{
	protected $title     = 'login';
	protected $presenter = 'Users:Front:Login';
	protected $action    = 'default';

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		return new BaseContainer;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{

	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		if ($this->presenter === $presenter && $this->action === $action) {
			return 1;
		}

		return false;
	}

	/**
	 * @param Navigation|DaoNavigationItem $navigation
	 * @param array                        $urlParams
	 */
	public function routerIn($navigation, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->isHomepage ? '' : '/' . $navigation->alias;
	}
}
