<?php declare(strict_types = 1);

namespace Users\Model;

use Core\Model\Helpers\BaseEntityService;
use Users\Model\Entities\Role;

/**
 * @method Role|null|object getReference($id)
 * @method Role[]|null getAll()
 * @method Role|null get($id)
 */
class Roles extends BaseEntityService
{
	protected $entityClass = Role::class;

	public function getByIdent(string $ident): ?Role
	{
		$query = $this->getEr()->createQueryBuilder('r', 'r.id')
			->andWhere('r.ident = :ident')->setParameter('ident', $ident);

		return $query->getQuery()->setMaxResults(1)->getOneOrNullResult();
	}

	/**
	 * @param string|int $id
	 */
	public function remove($id): bool
	{
		if ($entity = $this->get($id)) {
			if ($entity->ident === Role::SUPERADMIN) {
				return false;
			}

			$this->em->remove($entity);
			$this->em->flush();

			return true;
		}

		return false;
	}

	public function getForSelectOptions(): array
	{
		return $this->getEr()->findPairs([], 'name', ['name'], 'id');
	}
}
