<?php declare(strict_types = 1);

namespace Users\Model\Security;

use Nette\Security\IIdentity;

class FakeIdentity implements IIdentity
{
	public ?int $loggedByAnotherUser = null;

	/**
	 * @param int|array $id
	 */
	public function __construct(private $id, protected readonly string $class, protected string $userType = 'user')
	{
	}

	public function getId(): int|array
	{
		return $this->id;
	}

	public function getClass(): string
	{
		return $this->class;
	}

	public function getRoles(): array
	{
		return [];
	}

	public function getUserType(): string { return $this->userType; }
}
