<?php declare(strict_types = 1);

namespace Users\Model\Security;

use Users\Model\Entities\Role;
use Users\Model\Entities\User;
use Users\Model\Security\User as SecurityUser;

class IsRequired
{
	public function __construct(
		protected SecurityUser $user,
	)
	{
	}

	public function canEditUser(User $user): bool
	{
		return $this->user->isInRole(Role::SUPERADMIN)
			|| $this->user->isAllowed('Users:Admin', 'adminManager') && !$user->isInRoleByIdent(Role::SUPERADMIN)
			|| $this->user->isAllowed('Users:Admin', 'usersManager') && !$user->isInRoleByIdent(
				Role::SUPERADMIN,
			) && !$user->isInRoleByIdent(Role::ADMIN)
			|| $user->getId() === $this->user->getId();
	}

	public function canSetRole(string $ident): bool
	{
		return ($this->user->isInRole(Role::SUPERADMIN)
			|| ($this->user->isInRole(Role::ADMIN) && !in_array($ident, [Role::SUPERADMIN, Role::ADMIN], true)));
	}
}
