<?php declare(strict_types = 1);

namespace Users\Model;

use Core\Model\Entities\EntityManagerDecorator;
use Exception;
use Users\Model\Entities\UserAction;

class UserManager
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Users                  $users,
		protected UsersMailer            $usersMailer,
	)
	{
	}

	public function createForgotPasswordAction(string $email): bool
	{
		$user = $this->users->getByEmail($email);
		if (!$user)
			return false;

		try {
			$token      = md5(uniqid(random_bytes(5), true));
			$tokenHash  = md5($token);
			$userAction = new UserAction($user, UserAction::RESET_PASSWORD, $tokenHash);
			$user->addUserAction($userAction);
			$this->em->persist($userAction);
			$this->em->persist($user);
			$this->em->flush();
			$this->usersMailer->sendForgotPasswordLink($user->getEmail(), $token);
		} catch (Exception) {
			return false;
		}

		return true;
	}

	public function newUserEmailNotification(int $userId): bool
	{
		$user = $this->users->get($userId);
		if (!$user)
			return false;

		try {
			$token      = md5(uniqid(random_bytes(5), true));
			$tokenHash  = md5($token);
			$userAction = new UserAction($user, UserAction::RESET_PASSWORD, $tokenHash);
			$user->addUserAction($userAction);
			$this->em->persist($userAction);
			$this->em->persist($user)->flush($user);
			$this->usersMailer->sendNewUser($user, $token);
		} catch (Exception) {
			return false;
		}

		return true;
	}
}
