<?php declare(strict_types = 1);

namespace Users\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\ORM\Mapping\ClassMetadataInfo;
use Nette\Utils\DateTime;
use Users\Model\Entities\User;
use Users\Model\Security\User as UserSecurity;

class UsersActivity extends BaseEntityService
{

	protected $entityClass = User::class;

	public function setFirstSignIn(UserSecurity $userSecurity): void
	{
		bdump($userSecurity);
		/** @var User $user */
		$user = $this->get((int) $userSecurity->getId());

		if ($user->getFirstSignIn() !== null) {
			return;
		}

		$user->setFirstSignIn(new DateTime);

		$this->em->persist($user)
			->flush($user);
	}

	public function setLastActivity(int $userId): void
	{
		$qb = $this->em->createQueryBuilder();
		$qb->update($this->entityClass, 'u')
			->set('u.lastActivity', new DateTime)
			->where('u.id = :userId')
			->setParameter('userId', $userId);

		$qb->getQuery()->execute();
	}

	public function setLastActivityInAdmin(int $userId, bool $performanceMode = false): void
	{
		if (!$performanceMode) {
			$qb = $this->em->createQueryBuilder();
			$qb->update($this->entityClass, 'u')
				->set('u.lastActivityInAdmin', new DateTime)
				->where('u.id = :userId')
				->setParameter('userId', $userId);

			$qb->getQuery()->execute();
		} else {
			/** @var ClassMetadataInfo $metadata */
			/** @phpstan-ignore-next-line */
			$metadata  = $this->em->getClassMetadata($this->entityClass);
			$tableName = $metadata->getTableName();
			$this->em->getConnection()
				->executeQuery("UPDATE {$tableName} SET last_activity_in_admin = now() WHERE id = ?", [$userId]);
		}
	}

}
