<?php declare(strict_types=1);

namespace Weather\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Exception;
use Nette\Utils\ArrayHash;
use Weather\Model\Entities\Weather;
use Weather\Model\Repository\WeatherRepository;

class WeatherList extends BaseControl {

	/** @var WeatherRepository */
	private $weatherRepository;

	/**
	 * WeatherList constructor.
	 * @param WeatherRepository $weatherRepository
	 */
	public function __construct(WeatherRepository $weatherRepository)
	{
		parent::__construct();
		$this->weatherRepository = $weatherRepository;
	}

	/**
	 * @return BaseForm
	 */
	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();

		$items = $this->getWeatherItems();
		$countItems = count($items);
		$activeItem = $this->weatherRepository->getActiveWeatherResource();
		$defaultValue = $activeItem === null || $countItems === 1 ? array_key_first($items) : $activeItem->getIdent();

		$form->addRadioList('weatherItems', null, $items)
		     ->setRequired();

		if ($countItems > 0) {
			$form['weatherItems']->setDefaultValue($defaultValue);
		}

		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	/**
	 * @param BaseForm  $form
	 * @param ArrayHash $values
	 * @throws Exception
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		$this->weatherRepository->setActiveWeatherResource($values->weatherItems);
		$this->redirect('this');
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @return Weather[]
	 */
	private function getWeatherItems(): array
	{
		$result = [];
		foreach ($this->weatherRepository->getAll() as $item) {
			$result[$item->getIdent()] = $item->name;
		}

		return $result;
	}

}