<?php declare(strict_types=1);

namespace Weather\AdminModule\Presenters;

use Weather\AdminModule\Components\IWeatherListFactory;
use Weather\AdminModule\Components\WeatherList;

class DefaultPresenter extends BasePresenter
{

	public function startup() {
		parent::startup();
		$this->setHeader('weather.title.weather', 'fas fa-sun');
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionDefault()
	{

	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */

	/**
	 * @param IWeatherListFactory $factory
	 * @return WeatherList
	 */
	public function createComponentWeatherList(IWeatherListFactory $factory): WeatherList
	{
		return $factory->create();
	}

}