<?php declare(strict_types=1);

namespace Weather\DI;

use Core\DI\CompilerExtension;
use Nette;

class WeatherExtension extends CompilerExtension {

	public function loadConfiguration(): void {
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		Nette\DI\Compiler::loadDefinitions($this->getContainerBuilder(), $this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void {
		parent::beforeCompile();
		$this->setMapping(['Weather' => 'Weather\*Module\Presenters\*Presenter']);
	}

}