<?php declare(strict_types=1);

namespace Weather\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table("weather__weather")
 * @ORM\Entity
 */
class Weather {

	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false, unique=true)
	 */
	protected $ident;

	/**
	 * @var string
	 * @ORM\Column(type="string")
	 */
	public $name;

	/**
	 * @var boolean
	 * @ORM\Column(type="boolean")
	 */
	public $isActive;

	/**
	 * Weather constructor.
	 * @param string $ident
	 * @param string $name
	 * @param bool   $isActive
	 */
	public function __construct(string $ident, string $name, bool $isActive = false) {
		$this->ident = $ident;
		$this->name = $name;
		$this->isActive = $isActive;
	}

}