<?php declare(strict_types=1);

namespace Weather\Model\Repository;

use Doctrine\ORM\EntityManager;
use RuntimeException;
use Nette\DI\Container;
use Weather\Model\WeatherHandlers\IWeatherHandler;

class WeatherServiceFactory
{

	/** @var EntityManager */
	protected $em;

	/** @var Container */
	protected $container;

	/** @var WeatherRepository */
	protected $weatherRepository;

	/**
	 * IWeatherHandlerFactory constructor.
	 * @param WeatherRepository $weatherRepository
	 * @param Container         $container
	 */
	public function __construct(WeatherRepository $weatherRepository, Container $container) {
		$this->weatherRepository = $weatherRepository;
		$this->container = $container;
	}

	/**
	 * @return IWeatherHandler
	 */
	public function create(): IWeatherHandler {

		$weather = $this->weatherRepository->getActiveWeatherResource();

		if ($weather === null) {
			throw new RuntimeException('Weather resource is not in database or is not active');
		}

		return $this->findHandler($weather->getIdent());
	}

	/**
	 * @param string $ident
	 * @return IWeatherHandler
	 */
	private function findHandler(string $ident): IWeatherHandler {
		foreach ($this->container->findByType(IWeatherHandler::class) as $serviceName) {
			$parts = explode('.', $serviceName);
			$key = $parts[array_key_last($parts)];

			if ($key === $ident) {

				/** @var IWeatherHandler $service */
				$service = $this->container->getService($serviceName);
				return $service;
			}
		}

		throw new RuntimeException($ident . ' is not registred in services.neon');
	}

}