<?php declare(strict_types=1);

namespace Weather\Model\WeatherHandlers;

use Nette\DI\Container;
use Nette\Localization\ITranslator;

abstract class BaseWeatherHandler {

	/** @var array */
	protected $config;

	/** @var string */
	protected $lang;

	/** @var Container */
	protected $container;

	/**
	 * @param array $parameters
	 */
	public function setParameters(array $parameters): void {
		$this->config = $parameters;
	}

	/**
	 * @param ITranslator $translator
	 */
	public function setTranslator(ITranslator $translator): void {
		$this->lang = $translator->getLocale();
	}

	/**
	 * @param Container $container
	 */
	public function setContainer(Container $container): void {
		$this->container = $container;
	}

	/**
	 * @return string
	 */
	abstract public function getIdent(): string;

	/**
	 * @return array
	 */
	protected function getConfig(): array {
		return $this->config[$this->getIdent()];
	}

	// TODO nejaka moznost cachovani, jestlize budou stale dotazy na pocasi v Praze

}