<?php declare(strict_types=1);

namespace Weather\AdminModule\Components;

use Contributte\Translation\Wrappers\NotTranslate;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Exception;
use Nette\Utils\ArrayHash;
use Weather\Model\Entities\Weather;
use Weather\Model\Repository\WeatherRepository;

class WeatherList extends BaseControl
{

	/** @var WeatherRepository */
	private WeatherRepository $weatherRepository;

	/**
	 * WeatherList constructor.
	 * @param WeatherRepository $weatherRepository
	 */
	public function __construct(WeatherRepository $weatherRepository)
	{
		$this->weatherRepository = $weatherRepository;
	}

	public function render(): void
	{
		$this->template->thisForm = $this->getComponent('form');
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @return BaseForm
	 */
	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setShowLangSwitcher(false);

		$items = $this->getWeatherItems();
		$countItems = count($items);
		$activeItem = $this->weatherRepository->getActiveWeatherResource();
		$defaultValue = $activeItem === null || $countItems === 1 ? array_key_first($items) : $activeItem->getIdent();

		$form->addSelect('weatherItems', 'weather.tabs.resourceTab', $items)
		     ->setRequired();

		if ($countItems > 0) {
			$form['weatherItems']->setDefaultValue($defaultValue);
		}

		$form->addSubmit('submit', 'default.save');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	/**
	 * @param BaseForm  $form
	 * @param ArrayHash $values
	 * @throws Exception
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values): void
	{
		$this->weatherRepository->setActiveWeatherResource($values->weatherItems);
		$this->redirect('this');
	}

	/**
	 * @return Weather[]
	 */
	private function getWeatherItems(): array
	{
		$result = [];
		foreach ($this->weatherRepository->getAll() as $item) {
			$result[$item->getIdent()] = new NotTranslate($item->name);
		}

		return $result;
	}

}