<?php declare(strict_types=1);

namespace Weather\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Nette\SmartObject;

/**
 * @ORM\Table("weather__weather")
 * @ORM\Entity
 *
 * @property-read string $ident
 * @property string $name
 * @property bool $isActive
 */
class Weather
{
	use SmartObject;

	/**
	 * @var string
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false, unique=true)
	 */
	protected string $ident;

	/**
	 * @var string
	 * @ORM\Column(type="string")
	 */
	protected string $name;

	/**
	 * @var boolean
	 * @ORM\Column(type="boolean")
	 */
	protected bool $isActive;

	/**
	 * Weather constructor.
	 * @param string $ident
	 * @param string $name
	 * @param bool   $isActive
	 */
	public function __construct(string $ident, string $name, bool $isActive = false) {
		$this->ident = $ident;
		$this->name = $name;
		$this->isActive = $isActive;
	}

	/**
	 * @return string
	 */
	public function getIdent(): string
	{
		return $this->ident;
	}

	/**
	 * @param string $ident
	 */
	public function setIdent(string $ident): void
	{
		$this->ident = $ident;
	}

	/**
	 * @return string
	 */
	public function getName(): string
	{
		return $this->name;
	}

	/**
	 * @param string $name
	 */
	public function setName(string $name): void
	{
		$this->name = $name;
	}

	/**
	 * @return bool
	 */
	public function isActive(): bool
	{
		return $this->isActive;
	}

	/**
	 * @param bool $isActive
	 */
	public function setIsActive(bool $isActive): void
	{
		$this->isActive = $isActive;
	}

}