<?php

namespace Weather\Model\Repository;

use Core\Model\Helpers\BaseEntityService;
use Exception;
use Weather\Model\Entities\Weather;

/**
 * Class WeatherRepository
 * @package Weather\Model\Repository
 *
 * @method Weather[] getAll
 */
class WeatherRepository extends BaseEntityService {

	/** @var string */
	protected $entityClass = Weather::class;

	/**
	 * @return Weather|null
	 */
	public function getActiveWeatherResource(): ?Weather {
		return $this->em->getRepository(Weather::class)->findOneBy(['isActive' => true]);
	}

	/**
	 * @param string $ident
	 * @throws Exception
	 */
	public function setActiveWeatherResource(string $ident): void {
		try {
			$this->em->beginTransaction();

			// set all to false
			$this->em->createQueryBuilder()
			         ->update(Weather::class, 'w')
			         ->set('w.isActive', ':isActive')
			         ->setParameter('isActive', false)
			         ->getQuery()->execute();

			// set one to active by ident
			$this->em->createQueryBuilder()
			         ->update(Weather::class, 'w')
			         ->set('w.isActive', ':isActive')
			         ->setParameter('isActive', true)
			         ->where('w.ident = :ident')
			         ->setParameter('ident', $ident)
			         ->getQuery()->execute();

			$this->em->commit();
		}
		catch (Exception $exception) {
			$this->em->rollback();
			throw $exception;
		}
	}

}