<?php declare(strict_types=1);

namespace Weather\Model\Utils;

class Unit {

	/** @var string */
	private $unit;

	/** @var float */
	private $value;

	/** @var string */
	private $description;

	/**
	 * Unit constructor.
	 * @param string $unit
	 * @param float  $value
	 * @param string $description
	 */
	public function __construct(string $unit, float $value, string $description) {
		$this->unit = $unit;
		$this->value = $value;
		$this->description = $description;
	}

	/**
	 * @return string
	 */
	public function getUnit(): string {
		return $this->unit;
	}

	/**
	 * @return float
	 */
	public function getValue(): float {
		return $this->value;
	}

	/**
	 * @return string
	 */
	public function getDescription(): string {
		return $this->description;
	}

}