<?php declare(strict_types=1);

namespace Weather\Model\WeatherHandlers;

use Weather\Model\Entities\CurrentWeather;
use Weather\Model\Entities\WeatherForecast;

interface IWeatherHandler {

	/**
	 * @return string
	 */
	public function getIdent(): string;

	/**
	 * @param string $destination
	 * @return CurrentWeather
	 */
	public function getWeather(string $destination): CurrentWeather;

	/**
	 * @param string $destination
	 * @param int    $days
	 * @return WeatherForecast
	 */
	public function getWeatherForecast(string $destination, int $days): WeatherForecast;

}