<?php declare(strict_types = 1);

namespace Zasilkovna\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;
use EshopOrders\Model\Entities\Order;

/**
 * @ORM\Table(name="zasilkovna__order")
 * @ORM\Entity
 */
class ZasilkovnaOrder
{
	use MagicAccessors;

	/**
	 * @var Order
	 * @ORM\Id
	 * @ORM\OneToOne(targetEntity="\EshopOrders\Model\Entities\Order")
	 * @ORM\JoinColumn(name="order_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $order;

	/**
	 * @var string
	 * @ORM\Column(name="parcel_id", type="string")
	 */
	protected $parcelId;

	/**
	 * @var string
	 * @ORM\Column(name="parcel_name", type="string")
	 */
	public $parcelName;

	/**
	 * @var DateTime
	 * @ORM\Column(name="exported", type="datetime", nullable=true)
	 */
	private $exported;

	/**
	 * @var string
	 * @ORM\Column(name="export_type", type="string", nullable=true)
	 */
	private $exportType;

	public function __construct(Order $order, string $parcelId)
	{
		$this->order    = $order;
		$this->parcelId = $parcelId;
	}

	public function getOrder(): Order { return $this->order; }

	public function getParcelId(): string { return $this->parcelId; }

	public function export(string $type, ?DateTime $datetime = null): self
	{
		$this->exportType = $type;
		$this->exported   = $datetime ?: new DateTime();

		return $this;
	}

	public function getExportType(): ?string { return $this->exportType; }

	public function getExported(): ?DateTime { return $this->exported; }
}
