<?php declare(strict_types = 1);

namespace Zasilkovna\Model;

use EshopCatalog\FrontModule\Model\Products;
use EshopOrders\Model\Entities\Order;
use Kdyby\Doctrine\EntityManager;
use SoapClient;
use SoapFault;
use Tracy\Debugger;
use Zasilkovna\Model\Entities\ZasilkovnaOrder;

class OrderApiService
{
	/** @var array */
	protected $zasilkovna;

	/** @var EntityManager */
	protected $em;

	public function __construct(array $zasilkovna, EntityManager $em)
	{
		$this->zasilkovna = $zasilkovna;
		$this->em         = $em;
	}

	/**
	 * @param ZasilkovnaOrder[] $orders
	 *
	 * @return array
	 * @throws SoapFault
	 */
	public function generateOrderOverApi(array $orders): array
	{
		$gw          = new SoapClient("http://www.zasilkovna.cz/api/soap.wsdl");
		$apiPassword = $this->zasilkovna['apiPassword'];
		$result      = [
			'ok'    => 0,
			'error' => 0,
		];

		foreach ($orders as $zo) {
			/** @var ZasilkovnaOrder $zo */
			try {
				$order  = $zo->getOrder();
				$adress = $order->getAddressDelivery();
				$packet = $gw->createPacket($apiPassword, [
					'number'    => (string) $order->getId(),
					'name'      => $adress->getFirstName(),
					'surname'   => $adress->getLastName(),
					'email'     => $adress->getEmail(),
					'phone'     => $adress->getPhone(),
					'addressId' => $zo->getParcelId(),
					'cod'       => $order->getPrice(),
					'value'     => $order->getPriceItems(),
					'currency'  => 'CZK',
					'eshop'     => $this->zasilkovna['eshopName'],
				]);

				$zo->export('api');
				$this->em->persist($zo)->flush();
				$result['ok']++;
			} catch (\Exception $e) {
				Debugger::log($e->getMessage(), 'zasilkovnaApi');
				$result['error']++;
			}
		}

		return $result;
	}
}
