<?php declare(strict_types = 1);

namespace Zasilkovna\Model;

use Core\Model\Helpers\BaseEntityService;
use Doctrine\Common\Collections\ArrayCollection;
use EshopOrders\Model\Entities\Order;
use Zasilkovna\Model\Entities\ZasilkovnaOrder;
use Nette\Utils\DateTime;

/**
 * class OrdersExported
 * @package MoneyS3\Model
 *
 * @method ZasilkovnaOrderExported|object|null getReference($id)
 * @method ZasilkovnaOrderExported[]|null getAll()
 * @method ZasilkovnaOrderExported|null get($id)
 */
class OrdersExported extends BaseEntityService
{
	/**
	 * Vrati seznam objednavek, ktere jeste nebyly exportovany do XML
	 *
	 * @return ZasilkovnaOrder[]
	 */
	public function getOrdersNotExported(array $filtrIds = [])
	{
		$expr = $this->em->getExpressionBuilder();

		//objednavky ktere nejsou v seznamu zpracovanych objednavek
		$ordersQuery = $this->em->getRepository(ZasilkovnaOrder::class)->createQueryBuilder('zo')
			->select('o, zo, oad, oai, os, s')
			->join('zo.order', 'o')
			->leftJoin('o.addressDelivery', 'oad')
			->leftJoin('o.addressInvoice', 'oai')
			->leftJoin('o.spedition', 'os')
			->leftJoin('os.spedition', 's')
			->where('zo.exported IS NULL')
			->orderBy('o.id')->groupBy('o.id');

		if (!empty($filtrIds))
			$ordersQuery->andWhere('zo.order IN (:ids)')->setParameter('ids', $filtrIds);

		$orders = $ordersQuery->getQuery()->getResult();

		return $orders;
	}
}
