<?php declare(strict_types = 1);

namespace Zasilkovna\Model;

use Core\Model\Helpers\BaseService;
use Nette\Caching\Cache;

class Branches extends BaseService
{
	const CACHE_NAMESPACE = 'zasilkovnaBranches';

	/** @var array */
	protected $data;

	/** @var Cache */
	protected $cache;

	protected function getCache()
	{
		if ($this->cache === null)
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);

		return $this->cache;
	}

	public function getBranch(int $id)
	{
		return $this->getData()[$id] ?? null;
	}

	protected function getData(): array
	{
		if ($this->data === null) {
			$this->data = $this->getCache()->load('zasilkovnaBranches', function(&$dep) {
				$dep = [
					Cache::EXPIRATION => '1 hour',
				];

				try {
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch, CURLOPT_URL, 'http://www.zasilkovna.cz/api/v3/' . ZasilkovnaConfig::load('apiKey') . '/branch.json');
					$result = curl_exec($ch);
					curl_close($ch);

					$data = json_decode($result, true);

					return $data['data'];
				} catch (\Exception $e) {
				}

				return [];
			});

		}

		return $this->data;
	}
}
