function bindOpenWidgetElements() {
	for (let i in packetaWidgetSettings) {
		let el = document.getElementById(packetaWidgetSettings[i].selectorOpen);

		el.onclick = function () {
			Packeta.Widget.pick(packetaWidgetKey, function (point) {
				if (!point) {
					return;
				}

				document.getElementById(packetaWidgetSettings[i].selectorOpen).value               = point.name;
				document.getElementById(packetaWidgetSettings[i].selectorTarget).value             = point.id;
				document.getElementById(packetaWidgetSettings[i].carrierIdTarget).value            = point.carrierId;
				document.getElementById(packetaWidgetSettings[i].carrierPickupPointIdTarget).value = point.carrierPickupPointId;

				['street2', 'city2', 'postal2'].forEach(name => {
					let el = document.querySelector('[name="' + name + '"]');

					if (!el) {
						return true;
					}

					let val = '';
					if (name === 'street2') {
						val = point.street;
					} else if (name === 'city2') {
						val = point.city;
					} else if (name === 'postal2') {
						val = point.zip.replace(' ', '').replace('-', '');
					}

					if (val !== '') {
						el.value = val;
					}
				})

				let e = new CustomEvent('pickup-changed', {
					detail: {
						expedition: 'zasilkovna'
					},
				});

				window.dispatchEvent(e);

			}, packetaWidgetSettings[i]);
		};
	}
}

bindOpenWidgetElements();
