<?php declare(strict_types = 1);

namespace Zasilkovna\Model;

use Core\Model\Helpers\BaseService;
use Exception;
use Nette\Caching\Cache;
use Nette\Utils\Json;

class Branches extends BaseService
{
	public const CACHE_NAMESPACE = 'zasilkovnaBranches';
	protected ?array $data        = null;
	protected array  $carrierData = [];

	protected function getCache(): Cache
	{
		if ($this->cache === null) {
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);
		}

		return $this->cache;
	}

	public function getBranch(int $id, ?int $carrierId = null): ?array
	{
		if ($carrierId) {
			return $this->getCarrierData($carrierId)[$id] ?? null;
		}

		return $this->getData()[$id] ?? null;
	}

	protected function getCarrierData(int $carrierId): array
	{
		if (!array_key_exists($carrierId, $this->carrierData)) {
			try {
				ini_set('memory_limit', '512M');
				$this->carrierData[$carrierId] = $this->getCache()->load('branches/carrier/' . $carrierId, function(&$dep) use ($carrierId) {
					$dep  = [
						Cache::Tags   => ['branches'],
						Cache::Expire => '1 hour',
					];
					$list = [];

					$json = file_get_contents(sprintf('https://pickup-point.api.packeta.com/v5/%s/carrier_point/json?ids[]=' . $carrierId, ZasilkovnaConfig::loadString('apiKey') ?: ''));

					if (is_bool($json)) {
						return [];
					}

					foreach (Json::decode($json, forceArrays: true)['carriers'][0]['points'] as $row) {
						$list[$row['code']]           = $row;
						$list[$row['code']]['street'] = $row['street'] . ($row['streetNumber'] ? ', ' . $row['streetNumber'] : '');
						$list[$row['code']]['name']   = $row['street'] . ($row['streetNumber'] ? ', ' . $row['streetNumber'] : '') . ' ' . $row['city'] . ' ' . $row['postal_code'];
					}

					return $list;
				});
			} catch (Exception) {
				$this->carrierData[$carrierId] = [];
			}
		}

		return $this->carrierData[$carrierId];
	}

	protected function getData(): array
	{
		if ($this->data === null) {
			try {
				ini_set('memory_limit', '512M');
				$this->data = (array) $this->getCache()->load('branches', function(&$dep) {
					$dep  = [
						Cache::Tags   => ['branches'],
						Cache::Expire => '1 hour',
					];
					$list = [];

					$json = file_get_contents(sprintf('https://www.zasilkovna.cz/api/v6/%s/branch.json', ZasilkovnaConfig::loadString('apiKey') ?: ''));

					if (is_bool($json)) {
						return [];
					}

					foreach (Json::decode($json, forceArrays: true)['data'] as $row) {
						$list[$row['id']] = $row;
					}

					return $list;
				});
			} catch (Exception) {
				$this->data = [];
			}
		}

		return $this->data;
	}
}
