<?php declare(strict_types = 1);

namespace Zasilkovna\Model\Subscribers;

use Contributte\Translation\Translator;
use Core\Model\Entities\EntityManagerDecorator;
use EshopOrders\Model\Event\EmailEvent;
use EshopOrders\Model\Helpers\OrderHelper;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Zasilkovna\Model\OrdersExported;

class OrderEmailSubscriber implements EventSubscriberInterface
{
	public function __construct(
		protected EntityManagerDecorator $em,
		protected Translator             $translator,
		protected OrdersExported         $ordersExported
	)
	{
		$this->em = $em;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.emailChangeOrderStatus' => 'emailChangeOrderStatus',
		];
	}

	public function emailChangeOrderStatus(EmailEvent $event): void
	{
		if (!$event->status || !OrderHelper::canSendTrackingUrl($event->status) || !$event->order->getId()) {
			return;
		}

		$exported = $this->ordersExported->getOrdersExported([$event->order->getId()])[$event->order->getId()] ?? null;

		if ($exported && $exported->numberPackage) {
			$event->template->trackingUrl    = $exported->getTrackingUrl();
			$event->template->trackingNumber = $exported->numberPackage;
		}
	}
}
