<?php declare(strict_types = 1);

namespace Zasilkovna\DI;

use Core\DI\CompilerExtension;
use Nette;

class ZasilkovnaExtension extends CompilerExtension
{
	public function loadConfiguration()
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile()
	{
		parent::beforeCompile();
		$this->setMapping(['Zasilkovna' => 'Zasilkovna\*Module\Presenters\*Presenter']);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class)
	{
		parent::afterCompile($class);
		$init = $class->methods["initialize"];

		$init->addBody('Zasilkovna\Model\ZasilkovnaConfig::setParams($this->parameters[\'zasilkovna\']);');
	}
}
