<?php declare(strict_types=1);

namespace Zasilkovna\Model\Entities;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="zasilkovna__parcel_number")
 * @ORM\Entity
 */
class ZasilkovnaParcelNumber
{
	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", nullable=false)
	 */
	public string $numberPackage;

	/**
	 * @ORM\ManyToOne(targetEntity="ZasilkovnaOrder", inversedBy="associatedNumberPackages")
	 * @ORM\JoinColumn(name="parcel_order_id", referencedColumnName="order_id", nullable=false, onDelete="CASCADE")
	 */
	protected ZasilkovnaOrder $parcelOrder;

	public function __construct(string $numberPackage, ZasilkovnaOrder $parcelOrder)
	{
		$this->numberPackage = $numberPackage;
		$this->parcelOrder = $parcelOrder;
	}

	public function getNumberPackage(): string
	{
		return $this->numberPackage;
	}
}