<?php declare(strict_types = 1);

namespace Zasilkovna\Model;

use DOMDocument;
use DOMElement;
use DOMException;
use Zasilkovna\Model\Entities\ZasilkovnaOrder;

class OrderXmlService
{
	protected array $zasilkovna;

	public function __construct(array $zasilkovna)
	{
		$this->zasilkovna = $zasilkovna;
	}

	/**
	 * @param ZasilkovnaOrder[] $orders
	 * @throws DOMException
	 */
	public function generateOrderXml(array $orders): DOMDocument
	{
		$default_xml = $this->getDefaultOrderXml();

		$dom               = new DOMDocument;
		$dom->formatOutput = true;
		$dom->encoding     = 'utf-8';

		$dom->loadXML($default_xml);

		$parcels = $dom->getElementsByTagName('parcels')->item(0);
		foreach ($orders as $zo) {
			$orderXml = $this->generateOrderInnerXml($dom, $zo);

			$parcels->appendChild($orderXml);
		}

		return $dom;
	}

	public function getDefaultOrderXml(): string
	{
		return '<' . '?xml version="1.0" encoding="UTF-8"?' . '>' .
			'<parcels version="1">' . PHP_EOL .
			'</parcels>';
	}

	/**
	 * @param DOMDocument $dom
	 * @throws DOMException
	 */
	public function generateOrderInnerXml($dom, ZasilkovnaOrder $zo): DOMElement
	{
		$order    = $zo->getOrder();
		$orderXml = $dom->createElement('parcel');

		$child = $dom->createElement('orderNumber', (string) $order->getId()); //PrimDoklad
		$orderXml->appendChild($child);

		$child = $dom->createElement('senderLabel', $this->zasilkovna['eshopName']);
		$orderXml->appendChild($child);

		$adress = $order->getAddressDelivery();

		$child = $dom->createElement('name', $adress->getFirstName());
		$orderXml->appendChild($child);

		$child = $dom->createElement('surname', $adress->getLastName());
		$orderXml->appendChild($child);

		$child = $dom->createElement('phoneNumber', $adress->getPhone());
		$orderXml->appendChild($child);

		$child = $dom->createElement('currency', $order->currency ? $order->currency->code : '');
		$orderXml->appendChild($child);

		$child = $dom->createElement('cod', (string) $order->getPrice());
		$orderXml->appendChild($child);
		$child = $dom->createElement('value', (string) $order->getPriceItems());
		$orderXml->appendChild($child);

		$destinationXml = $dom->createElement('destination'); // TODO dodelat vydejni misto
		$orderXml->appendChild($destinationXml);
		// destination
		$child = $dom->createElement('pickupPointOrCarrier', '135');
		$destinationXml->appendChild($child);


		return $orderXml;
	}

}
