<?php declare(strict_types = 1);

namespace Zasilkovna\Model\Subscribers;

use Contributte\Translation\Translator;
use EshopOrders\Model\Event\EmailEvent;
use EshopOrders\Model\Helpers\OrderHelper;
use Nettrine\ORM\EntityManagerDecorator;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Zasilkovna\Model\OrdersExported;

class OrderEmailSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;
	protected Translator             $translator;
	protected OrdersExported         $ordersExported;

	public function __construct(
		EntityManagerDecorator $em,
		Translator             $translator,
		OrdersExported         $ordersExported
	)
	{
		$this->em             = $em;
		$this->translator     = $translator;
		$this->ordersExported = $ordersExported;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.emailChangeOrderStatus' => 'emailChangeOrderStatus',
		];
	}

	public function emailChangeOrderStatus(EmailEvent $event): void
	{
		if (!OrderHelper::canSendTrackingUrl($event->status)) {
			return;
		}

		$exported = $this->ordersExported->getOrdersExported([$event->order->getId()])[$event->order->getId()] ?? null;

		if ($exported && $exported->numberPackage) {
			$event->template->trackingUrl    = $exported->getTrackingUrl();
			$event->template->trackingNumber = $exported->numberPackage;
		}
	}
}
