<?php declare(strict_types = 1);

namespace Zasilkovna\Model\Subscribers;

use Core\Model\Event\Event;
use EshopOrders\AdminModule\Model\Statuses;
use EshopOrders\Model\Entities\OrderStatus;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Tracy\Debugger;
use Zasilkovna\Model\OrderApiService;
use Zasilkovna\Model\OrdersExported;

class OrderSubscriber implements EventSubscriberInterface
{
	protected Statuses $statuses;
	protected OrdersExported $ordersExported;
	protected OrderApiService $orderApiService;

	public function __construct(Statuses $statuses, OrdersExported $ordersExported, OrderApiService $orderApiService)
	{
		$this->statuses        = $statuses;
		$this->ordersExported  = $ordersExported;
		$this->orderApiService = $orderApiService;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orders.checkCompleted' => 'checkCompleted',
		];
	}

	public function checkCompleted(Event $event): void
	{
		$orders = $this->ordersExported->getOrdersNotCompleted();

		$completed = [];
		foreach ($orders as $id => $uo) {
			if ($this->orderApiService->checkCompleted($uo)) {
				$completed[] = $id;
			}
		}

		if (!empty($completed)) {
			try {
				$result = $this->statuses->changeStatus($completed, OrderStatus::STATUS_FINISHED);

				if ($result) {
					$this->ordersExported->markAsCompleted($completed);
				}
			} catch (\Exception $e) {
				Debugger::log('Zasilkovna error - ' . $e->getMessage(), 'ordersCheckComplete');
				Debugger::log($e);
			}
		}

		$this->ordersExported->em->clear();
	}
}
